/*
 * SoundManager.h
 *
 *  Created on: 15.07.2011
 *      Author: stefan.detter
 */

#ifndef SOUNDMANAGER_H_
#define SOUNDMANAGER_H_

#include "Sound.h"

#include <QObject>
#include <QFileInfo>
#include <QMap>

#include "../Resource.h"

class SoundPlayer;

class SoundManager : public QObject
{
	Q_OBJECT

	SoundManager(QObject* parent = 0);
public:
	virtual ~SoundManager();

	QStringList 	playlist();

	uint 	parallelCount();
	void 	setParallelCount(uint count);

public slots:
	void playSound(int index);

public slots:
	void addFileRequest ( const QFileInfo& file, bool& yesToAll, bool& result, QString& errMsg );

public:
	static SoundManager* 	d;
	static void initInstance(QObject* parent = 0);

private:
	bool 	reloadFiles();
	bool 	checkFile ( const QFileInfo& file, QString& err );

private:
	QMap<QString, QFileInfo>	m_files;
	uint 						m_parallelCount;
	SoundPlayer*				m_soundPlayer;
};



#endif /* SOUNDMANAGER_H_ */
